import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay_agent/core/route/route.dart';
import 'package:viserpay_agent/core/utils/dimensions.dart';
import 'package:viserpay_agent/core/utils/my_color.dart';
import 'package:viserpay_agent/core/utils/my_strings.dart';
import 'package:viserpay_agent/data/controller/add_money/add_money_history_controller.dart';
import 'package:viserpay_agent/data/repo/add_money/add_money_history_repo.dart';
import 'package:viserpay_agent/data/services/api_service.dart';
import 'package:viserpay_agent/view/components/app-bar/action_button_icon_widget.dart';
import 'package:viserpay_agent/view/components/app-bar/custom_appbar.dart';
import 'package:viserpay_agent/view/components/custom_loader/custom_loader.dart';
import 'package:viserpay_agent/view/components/no_data.dart';
import 'package:viserpay_agent/view/screens/add-money/add_money_history/widget/add_money_history_card.dart';
import 'package:viserpay_agent/view/screens/add-money/add_money_history/widget/add_money_history_filter_widget.dart';

class AddMoneyHistoryScreen extends StatefulWidget {
  const AddMoneyHistoryScreen({super.key});

  @override
  State<AddMoneyHistoryScreen> createState() => _AddMoneyHistoryScreenState();
}

class _AddMoneyHistoryScreenState extends State<AddMoneyHistoryScreen> {
  final ScrollController scrollController = ScrollController();

  void scrollListener() {
    if (scrollController.position.pixels == scrollController.position.maxScrollExtent) {
      if (Get.find<AddMoneyHistoryController>().hasNext()) {
        Get.find<AddMoneyHistoryController>().loadPaginationData();
      }
    }
  }

  @override
  void initState() {
    Get.put(ApiClient(sharedPreferences: Get.find()));
    Get.put(AddMoneyHistoryRepo(apiClient: Get.find()));
    final controller = Get.put(AddMoneyHistoryController(addMoneyHistoryRepo: Get.find()));
    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      controller.initialSelectedValue();
      scrollController.addListener(scrollListener);
    });
  }

  @override
  void dispose() {
    scrollController.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<AddMoneyHistoryController>(
      builder: (controller) => Scaffold(
        backgroundColor: MyColor.screenBgColor,
        appBar: CustomAppBar(
          title: MyStrings.addMoneyHistory,
          action: [
            ActionButtonIconWidget(
              pressed: () => controller.changeSearchStatus(),
              icon: controller.isSearch ? Icons.clear : Icons.search,
              backgroundColor: MyColor.primaryColor.withOpacity(0.1),
              iconColor: MyColor.primaryColor,
            ),
            Padding(
              padding: const EdgeInsetsDirectional.symmetric(horizontal: 10.0),
              child: ActionButtonIconWidget(
                pressed: () => Get.toNamed(RouteHelper.addMoneyScreen),
                icon: Icons.add,
                backgroundColor: MyColor.primaryColor.withOpacity(0.1),
                iconColor: MyColor.primaryColor,
              ),
            ),
          ],
        ),
        body: controller.isLoading
            ? const CustomLoader()
            : Padding(
                padding: const EdgeInsets.only(top: Dimensions.space20, left: Dimensions.space15, right: Dimensions.space15),
                child: SingleChildScrollView(
                  controller: scrollController,
                  child: Column(
                    children: [
                      Visibility(
                        visible: controller.isSearch,
                        child: const AddMoneyHistoryFilterWidget(),
                      ),
                      controller.depositList.isEmpty && controller.filterLoading == false
                          ? const Center(
                              child: NoDataWidget(),
                            )
                          : controller.filterLoading
                              ? const CustomLoader()
                              : Expanded(
                                  flex: 0,
                                  child: ListView.separated(
                                      shrinkWrap: true,
                                      scrollDirection: Axis.vertical,
                                      physics: const NeverScrollableScrollPhysics(),
                                      padding: EdgeInsets.zero,
                                      itemCount: controller.depositList.length + 1,
                                      separatorBuilder: (context, index) => const SizedBox(height: Dimensions.space10),
                                      itemBuilder: (context, index) {
                                        if (controller.depositList.length == index) {
                                          return controller.hasNext() ? const CustomLoader(isPagination: true) : const SizedBox();
                                        }
                                        return AddMoneyHistoryCard(index: index);
                                      }),
                                ),
                    ],
                  ),
                ),
              ),
      ),
    );
  }
}
